
// Persistence of Vision Ray Tracer Scene Description File
// File: daydream.pov
// Vers: 3
// Desc: IRTC 'School' entry
// Date: April 1, 1997
// Auth: Doug Sterrett



#include "colors.inc"
#include "textures.inc"
#include "METALS.INC"
#include "WOODS.INC"
#include "STONES.INC"
#include "GLASS.INC"

global_settings { max_trace_level 20
                  adc_bailout 0.0039
                  assumed_gamma 2.2
                }
/*
global_settings { ambient_light <1.0, 1.0, 0.1, 1.0, 1.0> }
*/

//#include "COORDS.INC"


#include "ROOM.INC"

#declare very_short =30.0
#declare short = 50.0 //cf Floor dimensions
#declare medium =80.0
#declare long = 200
#declare very_long = 300
#declare cosmic = 1000
#declare Focus_Point= <0.0, Floor_Down, 0.0>
#declare ShowFP=off
#declare Focal_Radius=10.0
#declare Focal= medium - Floor_Down
#declare View=1
//0=  special  manually enter
//1=  short/-Floor_Down/-short  near table low ****GOOD****
//2=   1/ 1/-1           rt/up/bk    CORNER SE UP
//3=   1/ 1/ 1           rt/up/fwd   CORNER NE UP
//4=  -1/ 1/ 1          lft/up/fwd   CORNER NW UP
//5=  -1/ 1/-1          lft/up/bk    CORNER SW UP
//6=   0/ 1/ 1            0/up/fwd   EDGE   N  UP
//7=   1/ 1/ 0           rt/up/0     EDGE   E  UP
//8=  -1/ 1/ 1          lft/up/fwd   EDGE   W  UP
//9=   0/ 1/-1            0/up/bk    EDGE   S  UP
//10=  0/ 1/ 0            0/up/0     CENTER UP        (OVERHEAD)
//11=  1/ Floor_Down/-1  rt/fl/bk    CORNER SE FLOOR
//12=  1/ Floor_Down/ 1  rt/fl/fwd   CORNER NE FLOOR
//13= -1/ Floor_Down/ 1 lft/fl/fwd   CORNER NW FLOOR
//14= -1/ Floor_Down/-1 lft/fl/bk    CORNER SW FLOOR
//15=  0/ Floor_Down/ 1   0/fl/fwd   EDGE   N  FLOOR
//16=  1/ Floor_Down/ 0  rt/fl/0     EDGE   E  FLOOR
//17= -1/ Floor_Down/ 1 lft/fl/fwd   EDGE   W  FLOOR
//18=  0/ Floor_Down/-1   0/fl/bk    EDGE   S  FLOOR

/////////////////////////////////////

#declare XSun= 18000.0
#declare YSun= 18000.0
#declare ZSun= -16000.0
#declare Sun_Radius = 5
#declare Sunshine= 1.0
#declare Star_Radius=350

#declare ltPW1=1.0
#declare ltPW2=0.9
#declare ltPW3=1.0
#declare ltPWstar=1.0
#declare ShowMark = off
#declare ShowHalo = off
#declare ShowSight=off
#declare Light_Bank=12999
//0
//1=      ceiling
//2=      back
//3=      fore
//4=      star sphere illumination
//5
//6
//7
//8
//99=     cloud
//999=    SUN only  - NO LIGHTS
//12=     ceiling/back
//13=     ceiling/fore
//23=     back/fore
//1999=   ceiling & SUN
//2999=   back/SUN
//3999=   fore/SUN
//4999=   star/SUN
//123=    ceiling/fore/back
//12999=  ceiling/back/SUN
//13999=  ceiling/fore/SUN
//14999=  ceiling/star/SUN
//23999=  back/fore/SUN
//99999=  SUN and cloud
//123999= ceiling/back/fore/SUN
//124999= ceiling/back/star/SUN
//1234999=SUN/star/fore/ceiling/back

#include "CAMERAS.INC"
#declare ShowSky=on
#include "LIGHTS.INC" /// includes universe.inc

#include "STREE.INC"

//#include "MAXWELL.INC"

#include "ALLTABLE.INC"

//#include "PLANET.INC"

#include "FRAME.INC"

//#include "TRELLIS_FLOWER.INC"

